/*
 * Decompiled with CFR 0.152.
 */
package com.lidroid.xutils.http;

import com.lidroid.xutils.HttpUtils;
import com.lidroid.xutils.util.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import org.apache.http.HttpResponse;

public class ResponseStream
extends InputStream {
    private HttpResponse baseResponse;
    private InputStream baseStream;
    private String charset;
    private String requestUrl;
    private String requestMethod;
    private long expiry;
    private String _directResult;

    public ResponseStream(HttpResponse baseResponse, String requestUrl, long expiry) throws IOException {
        this(baseResponse, "UTF-8", requestUrl, expiry);
    }

    public ResponseStream(HttpResponse baseResponse, String charset, String requestUrl, long expiry) throws IOException {
        if (baseResponse == null) {
            throw new IllegalArgumentException("baseResponse may not be null");
        }
        this.baseResponse = baseResponse;
        this.baseStream = baseResponse.getEntity().getContent();
        this.charset = charset;
        this.requestUrl = requestUrl;
        this.expiry = expiry;
    }

    public ResponseStream(String result) throws IOException {
        if (result == null) {
            throw new IllegalArgumentException("result may not be null");
        }
        this._directResult = result;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public InputStream getBaseStream() {
        return this.baseStream;
    }

    public HttpResponse getBaseResponse() {
        return this.baseResponse;
    }

    public int getStatusCode() {
        if (this._directResult != null) {
            return 200;
        }
        return this.baseResponse.getStatusLine().getStatusCode();
    }

    public Locale getLocale() {
        if (this._directResult != null) {
            return Locale.getDefault();
        }
        return this.baseResponse.getLocale();
    }

    public String getReasonPhrase() {
        if (this._directResult != null) {
            return "";
        }
        return this.baseResponse.getStatusLine().getReasonPhrase();
    }

    public String readString() throws IOException {
        if (this._directResult != null) {
            return this._directResult;
        }
        if (this.baseStream == null) {
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.baseStream, this.charset));
            StringBuilder sb = new StringBuilder();
            String line = "";
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            this._directResult = sb.toString();
            if (this.requestUrl != null && HttpUtils.sHttpCache.isEnabled(this.requestMethod)) {
                HttpUtils.sHttpCache.put(this.requestUrl, this._directResult, this.expiry);
            }
            String string = this._directResult;
            return string;
        }
        finally {
            IOUtils.closeQuietly(this.baseStream);
        }
    }

    public void readFile(String savePath) throws IOException {
        if (this._directResult != null) {
            return;
        }
        if (this.baseStream == null) {
            return;
        }
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(savePath));
            BufferedInputStream ins = new BufferedInputStream(this.baseStream);
            byte[] buffer = new byte[4096];
            int len = 0;
            while ((len = ins.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            out.flush();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            IOUtils.closeQuietly(this.baseStream);
            throw throwable;
        }
        IOUtils.closeQuietly(out);
        IOUtils.closeQuietly(this.baseStream);
    }

    @Override
    public int read() throws IOException {
        if (this.baseStream == null) {
            return -1;
        }
        return this.baseStream.read();
    }

    @Override
    public int available() throws IOException {
        if (this.baseStream == null) {
            return 0;
        }
        return this.baseStream.available();
    }

    @Override
    public void close() throws IOException {
        if (this.baseStream == null) {
            return;
        }
        this.baseStream.close();
    }

    @Override
    public void mark(int readLimit) {
        if (this.baseStream == null) {
            return;
        }
        this.baseStream.mark(readLimit);
    }

    @Override
    public boolean markSupported() {
        if (this.baseStream == null) {
            return false;
        }
        return this.baseStream.markSupported();
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        if (this.baseStream == null) {
            return -1;
        }
        return this.baseStream.read(buffer);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.baseStream == null) {
            return -1;
        }
        return this.baseStream.read(buffer, offset, length);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.baseStream == null) {
            return;
        }
        this.baseStream.reset();
    }

    @Override
    public long skip(long byteCount) throws IOException {
        if (this.baseStream == null) {
            return 0L;
        }
        return this.baseStream.skip(byteCount);
    }

    public long getContentLength() {
        if (this.baseStream == null) {
            return 0L;
        }
        return this.baseResponse.getEntity().getContentLength();
    }
}

